function limits = ExportBinBruker(Bin,expt)
    
    if expt == 1 % Exporting to .txt
        row1 = "A 1.0 #regions in PPM";
        row2 = "# low field   high field  bias        slope";
        
        HF_B = "0." + string(zeros(size(Bin, 1),1)) + " ";
        region = "# for region " + string(1:size(Bin, 1)); region = region';
        str_bin1 = string(flip(round(Bin(:,1),2))) + " ";
        str_bin2 = " " + string(flip(round(Bin(:,2),2))) + " ";
    
        labels = [row1;row2];
        limits = [str_bin2 + str_bin1 + HF_B + HF_B + region];
    
        limits = [labels;limits];

    elseif expt == 2 % Exporting to Excel
        row1 = string(["A" "1.0" "#regions" "in" "PPM"]);
        row2 = string(["#" "low field" "high field" "bias" "slope"]);
        
        HF_B = string(zeros(size(Bin, 1),1));
        region = "# for region " + string(1:size(Bin, 1)); region = region';
        str_bin = string(flip(round(Bin,2)));
    
        labels = [row1;row2];
        limits = [str_bin HF_B HF_B region];
    
        limits = [labels;limits];
    end
end